/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONBase;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.LegacyCompatSystem;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.ModelParserLT;
import minecrafttransportsimulator.systems.ConfigSystem;

public class JSONParser {
    private static final TypeAdapter<Boolean> booleanAdapter = new TypeAdapter<Boolean>(){

        public Boolean read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextBoolean();
        }

        public void write(JsonWriter writer, Boolean value) throws IOException {
            if (!value.booleanValue()) {
                writer.nullValue();
            } else {
                writer.value(value);
            }
        }
    };
    private static final TypeAdapter<Integer> integerAdapter = new TypeAdapter<Integer>(){

        public Integer read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextInt();
        }

        public void write(JsonWriter writer, Integer value) throws IOException {
            if (value == 0) {
                writer.nullValue();
            } else {
                writer.value((Number)value);
            }
        }
    };
    private static final TypeAdapter<Float> floatAdapter = new TypeAdapter<Float>(){

        public Float read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return Float.valueOf((float)reader.nextDouble());
        }

        public void write(JsonWriter writer, Float value) throws IOException {
            if (value.floatValue() == 0.0f) {
                writer.nullValue();
            } else {
                writer.value((Number)value);
            }
        }
    };
    private static final TypeAdapter<Point3D> point3DAdapter = new TypeAdapter<Point3D>(){

        public Point3D read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            Point3D value = new Point3D(reader.nextDouble(), reader.nextDouble(), reader.nextDouble());
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, Point3D value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                writer.value(value.x);
                writer.value(value.y);
                writer.value(value.z);
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<RotationMatrix> rotationMatrixAdapter = new TypeAdapter<RotationMatrix>(){

        public RotationMatrix read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            RotationMatrix value = new RotationMatrix().setToAngles(new Point3D(reader.nextDouble(), reader.nextDouble(), reader.nextDouble()));
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, RotationMatrix value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                writer.value(value.angles.x);
                writer.value(value.angles.y);
                writer.value(value.angles.z);
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<ColorRGB> colorAdapter = new TypeAdapter<ColorRGB>(){

        public ColorRGB read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                ArrayList<Integer> hsv = new ArrayList<Integer>();
                reader.beginArray();
                while (reader.hasNext()) {
                    hsv.add(reader.nextInt());
                }
                reader.endArray();
                float hue = ((Integer)hsv.get(0)).intValue();
                float sat = ((Integer)hsv.get(1)).intValue();
                float val = ((Integer)hsv.get(2)).intValue();
                return new ColorRGB(hue, sat, val, true);
            }
            return new ColorRGB(reader.nextString());
        }

        public void write(JsonWriter writer, ColorRGB value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else if (ConfigSystem.settings != null && ((Boolean)ConfigSystem.settings.general.useHSV.value).booleanValue()) {
                writer.beginArray();
                writer.setIndent("");
                int[] nArray = value.hsv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer item = nArray[i];
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            } else {
                StringBuilder hexString = new StringBuilder(Integer.toHexString(value.rgbInt).toUpperCase(Locale.ROOT));
                while (hexString.length() < 6) {
                    hexString.insert(0, "0");
                }
                writer.value(hexString.toString());
            }
        }
    };
    private static final TypeAdapter<ModelParserLT.LTBox> ltBoxAdapter = new TypeAdapter<ModelParserLT.LTBox>(){

        public ModelParserLT.LTBox read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            ModelParserLT.LTBox value = new ModelParserLT.LTBox();
            reader.nextString();
            value.pos1 = new int[]{reader.nextInt(), reader.nextInt(), reader.nextInt()};
            value.pos2 = new int[]{reader.nextInt(), reader.nextInt(), reader.nextInt()};
            while (reader.hasNext()) {
                reader.nextInt();
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, ModelParserLT.LTBox value) throws IOException {
            writer.nullValue();
        }
    };
    private static final TypeAdapter<List<Integer>> intListAdapter = new TypeAdapter<List<Integer>>(){

        public List<Integer> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<Integer> value = new ArrayList<Integer>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add(reader.nextInt());
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<Integer> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (Integer item : value) {
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<List<Float>> floatListAdapter = new TypeAdapter<List<Float>>(){

        public List<Float> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<Float> value = new ArrayList<Float>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add(Float.valueOf((float)reader.nextDouble()));
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<Float> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (Float item : value) {
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapterFactory lowercaseEnumFactory = new TypeAdapterFactory(){

        public <EnumType> TypeAdapter<EnumType> create(Gson gson, TypeToken<EnumType> type) {
            Class rawType = type.getRawType();
            if (!rawType.isEnum()) {
                return null;
            }
            final HashMap lowercaseToEnum = new HashMap();
            for (Object enumConstant : rawType.getEnumConstants()) {
                lowercaseToEnum.put(enumConstant.toString().toLowerCase(Locale.ROOT), enumConstant);
            }
            return new TypeAdapter<EnumType>(){

                public void write(JsonWriter writer, EnumType value) throws IOException {
                    if (value == null) {
                        writer.nullValue();
                    } else {
                        writer.value(value.toString().toLowerCase(Locale.ROOT));
                    }
                }

                public EnumType read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    return lowercaseToEnum.get(reader.nextString());
                }
            };
        }
    };
    private static final Gson packParser = JSONParser.getPackParserWithAdapters();
    private static final Gson configParser = JSONParser.getConfigParserWithAdapters();

    private static Gson getPackParserWithAdapters() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().registerTypeAdapter(Boolean.class, booleanAdapter).registerTypeAdapter(Integer.class, integerAdapter).registerTypeAdapter(Float.class, floatAdapter).registerTypeAdapter(Point3D.class, point3DAdapter).registerTypeAdapter(RotationMatrix.class, rotationMatrixAdapter).registerTypeAdapter(ColorRGB.class, colorAdapter).registerTypeAdapter(ModelParserLT.LTBox.class, ltBoxAdapter).registerTypeAdapter(new TypeToken<List<Integer>>(){}.getType(), intListAdapter).registerTypeAdapter(new TypeToken<List<Float>>(){}.getType(), floatListAdapter).registerTypeAdapterFactory(lowercaseEnumFactory).create();
    }

    private static Gson getConfigParserWithAdapters() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(new TypeToken<List<Integer>>(){}.getType(), intListAdapter).registerTypeAdapter(new TypeToken<List<Float>>(){}.getType(), floatListAdapter).create();
    }

    public static <JSONClass> JSONClass parseStream(InputStream stream, Class<JSONClass> retClass, String packID, String systemName) throws IOException {
        InputStreamReader jsonReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        Object json = AJSONBase.class.isAssignableFrom(retClass) ? packParser.fromJson((Reader)jsonReader, retClass) : configParser.fromJson((Reader)jsonReader, retClass);
        jsonReader.close();
        return (JSONClass)json;
    }

    public static void exportStream(Object jsonObject, OutputStream stream) throws IOException {
        OutputStreamWriter jsonWriter = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        if (AJSONBase.class.isAssignableFrom(jsonObject.getClass())) {
            packParser.toJson(jsonObject, jsonObject.getClass(), (Appendable)jsonWriter);
        } else {
            configParser.toJson(jsonObject, jsonObject.getClass(), (Appendable)jsonWriter);
        }
        jsonWriter.flush();
        jsonWriter.close();
    }

    public static <JSONClass> JSONClass duplicateJSON(JSONClass objToDuplicate) {
        return (JSONClass)packParser.fromJson(packParser.toJson(objToDuplicate), objToDuplicate.getClass());
    }

    public static String exportAllJSONs() {
        File jsonDir = new File(InterfaceManager.gameDirectory, "mts_dev");
        if (!jsonDir.exists() && !jsonDir.mkdir()) {
            return "ERROR: Could not create dev folder: " + jsonDir.getAbsolutePath() + "\nIs this location write-protected?";
        }
        File lastModifiedFile = new File(jsonDir, "lastexported.txt");
        if (lastModifiedFile.exists()) {
            return "ERROR: Existing export detected!  Exporting will not continue.  Either delete the mts_dev folder, or the lastexported.txt file and try again.";
        }
        long lastTimeModified = 0L;
        String debugText = "Export dir is: " + jsonDir.getAbsolutePath();
        for (String packID : PackParser.getAllPackIDs()) {
            File packDir = new File(jsonDir, packID);
            if (!packDir.exists() && !packDir.mkdir()) {
                return "ERROR: Could not create pack folder: " + packDir.getAbsolutePath() + "\nIs this location write-protected?";
            }
            ArrayList<JSONPanel> jsons = new ArrayList<JSONPanel>();
            PackParser.getAllItemsForPack(packID, false).forEach(item -> jsons.add((JSONPanel)item.definition));
            jsons.addAll(PackParser.getAllPanelsForPack(packID));
            for (AJSONBase aJSONBase : jsons) {
                try {
                    File jsonFile = new File(packDir, aJSONBase.classification.toDirectory() + aJSONBase.prefixFolders);
                    jsonFile.mkdirs();
                    jsonFile = new File(jsonFile, aJSONBase.systemName + ".json");
                    JSONParser.exportStream(aJSONBase, Files.newOutputStream(jsonFile.toPath(), new OpenOption[0]));
                    lastTimeModified = jsonFile.lastModified();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "ERROR: Could not save pack definition to disk.  Error is:\n" + e.getMessage();
                }
            }
            debugText = debugText + "\nExported pack: " + packID;
        }
        try {
            FileWriter writer = new FileWriter(lastModifiedFile);
            writer.write(String.valueOf(lastTimeModified));
            writer.flush();
            writer.close();
            debugText = debugText + "\nExporting finished.";
        }
        catch (IOException e) {
            return "ERROR: Could not save last modified timestamp to disk.  Error is:\n" + e.getMessage();
        }
        return debugText;
    }

    public static String importAllJSONs(boolean returnErrorsOnly) {
        File jsonDir = new File(InterfaceManager.gameDirectory, "mts_dev");
        if (jsonDir.exists()) {
            String debugText = returnErrorsOnly ? "" : "Import dir is: " + jsonDir.getAbsolutePath();
            File lastModifiedFile = new File(jsonDir, "lastexported.txt");
            if (lastModifiedFile.exists()) {
                long lastTimeModified;
                try {
                    FileReader reader = new FileReader(lastModifiedFile);
                    BufferedReader buffer = new BufferedReader(reader);
                    lastTimeModified = Long.parseLong(buffer.readLine());
                    buffer.close();
                }
                catch (Exception e) {
                    return "ERROR: Could not read last modified timestamp from disk.  Error is:\n" + e.getMessage();
                }
                HashSet<File> parsedFiles = new HashSet<File>();
                for (String packID : PackParser.getAllPackIDs()) {
                    File packDir = new File(jsonDir, packID);
                    if (!packDir.exists()) continue;
                    ArrayList<JSONPanel> jsons = new ArrayList<JSONPanel>();
                    PackParser.getAllItemsForPack(packID, false).forEach(item -> jsons.add((JSONPanel)item.definition));
                    jsons.addAll(PackParser.getAllPanelsForPack(packID));
                    for (AJSONBase aJSONBase : jsons) {
                        File jsonFile = new File(packDir, aJSONBase.classification.toDirectory() + aJSONBase.prefixFolders + aJSONBase.systemName + ".json");
                        if (parsedFiles.contains(jsonFile)) continue;
                        if (jsonFile.lastModified() > lastTimeModified) {
                            debugText = debugText + JSONParser.importJSON(jsonFile, aJSONBase, returnErrorsOnly);
                        }
                        parsedFiles.add(jsonFile);
                    }
                }
                if (returnErrorsOnly) {
                    if (debugText.isEmpty()) {
                        return "Imported with no errors.";
                    }
                    return debugText;
                }
                return debugText + "\nImporting finished.";
            }
            return "ERROR: No last modified timestamp file found at location: " + lastModifiedFile.getAbsolutePath() + "\nPlease re-export your pack data.";
        }
        return "ERROR: Could not find dev folder: " + jsonDir.getAbsolutePath();
    }

    public static String importJSON(File jsonFile, AJSONBase definitionToOverride, boolean returnErrorsOnly) {
        try {
            AJSONBase loadedDefinition;
            switch (definitionToOverride.classification) {
                case VEHICLE: {
                    JSONVehicle vehicleDefinition = (JSONVehicle)definitionToOverride;
                    JSONVehicle loadedVehicleDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONVehicle.class, vehicleDefinition.packID, vehicleDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedVehicleDefinition);
                    JSONParser.validateFields(loadedVehicleDefinition, "/", 1);
                    vehicleDefinition.motorized = loadedVehicleDefinition.motorized;
                    loadedDefinition = loadedVehicleDefinition;
                    break;
                }
                case PART: {
                    JSONPart partDefinition = (JSONPart)definitionToOverride;
                    JSONPart loadedPartDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONPart.class, partDefinition.packID, partDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedPartDefinition);
                    JSONParser.validateFields(loadedPartDefinition, "/", 1);
                    partDefinition.generic = loadedPartDefinition.generic;
                    partDefinition.engine = loadedPartDefinition.engine;
                    partDefinition.ground = loadedPartDefinition.ground;
                    partDefinition.propeller = loadedPartDefinition.propeller;
                    partDefinition.seat = loadedPartDefinition.seat;
                    partDefinition.gun = loadedPartDefinition.gun;
                    partDefinition.interactable = loadedPartDefinition.interactable;
                    partDefinition.effector = loadedPartDefinition.effector;
                    loadedDefinition = loadedPartDefinition;
                    break;
                }
                case INSTRUMENT: {
                    JSONInstrument instrumentDefinition = (JSONInstrument)definitionToOverride;
                    JSONInstrument loadedInstrumentDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONInstrument.class, instrumentDefinition.packID, instrumentDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedInstrumentDefinition);
                    JSONParser.validateFields(loadedInstrumentDefinition, "/", 1);
                    instrumentDefinition.components = loadedInstrumentDefinition.components;
                    loadedDefinition = loadedInstrumentDefinition;
                    break;
                }
                case DECOR: {
                    JSONDecor decorDefinition = (JSONDecor)definitionToOverride;
                    JSONDecor loadedDecorDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONDecor.class, decorDefinition.packID, decorDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedDecorDefinition);
                    JSONParser.validateFields(loadedDecorDefinition, "/", 1);
                    decorDefinition.decor = loadedDecorDefinition.decor;
                    loadedDefinition = loadedDecorDefinition;
                    break;
                }
                case ROAD: {
                    JSONRoadComponent roadDefinition = (JSONRoadComponent)definitionToOverride;
                    JSONRoadComponent loadedRoadDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONRoadComponent.class, roadDefinition.packID, roadDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedRoadDefinition);
                    JSONParser.validateFields(loadedRoadDefinition, "/", 1);
                    roadDefinition.road = loadedRoadDefinition.road;
                    loadedDefinition = loadedRoadDefinition;
                    break;
                }
                case POLE: {
                    JSONPoleComponent poleDefinition = (JSONPoleComponent)definitionToOverride;
                    JSONPoleComponent loadedPoleDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONPoleComponent.class, poleDefinition.packID, poleDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedPoleDefinition);
                    JSONParser.validateFields(loadedPoleDefinition, "/", 1);
                    loadedDefinition = loadedPoleDefinition;
                    break;
                }
                case BULLET: {
                    JSONBullet bulletDefinition = (JSONBullet)definitionToOverride;
                    JSONBullet loadedBulletDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONBullet.class, bulletDefinition.packID, bulletDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedBulletDefinition);
                    JSONParser.validateFields(loadedBulletDefinition, "/", 1);
                    bulletDefinition.bullet = loadedBulletDefinition.bullet;
                    loadedDefinition = loadedBulletDefinition;
                    break;
                }
                case ITEM: {
                    JSONItem itemDefinition = (JSONItem)definitionToOverride;
                    JSONItem loadedItemDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONItem.class, itemDefinition.packID, itemDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedItemDefinition);
                    JSONParser.validateFields(loadedItemDefinition, "/", 1);
                    itemDefinition.item = loadedItemDefinition.item;
                    itemDefinition.booklet = loadedItemDefinition.booklet;
                    itemDefinition.food = loadedItemDefinition.food;
                    itemDefinition.weapon = loadedItemDefinition.weapon;
                    loadedDefinition = loadedItemDefinition;
                    break;
                }
                case PANEL: {
                    JSONPanel panelDefinition = (JSONPanel)definitionToOverride;
                    JSONPanel loadedPanelDefinition = JSONParser.parseStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), JSONPanel.class, panelDefinition.packID, panelDefinition.systemName);
                    LegacyCompatSystem.performLegacyCompats(loadedPanelDefinition);
                    JSONParser.validateFields(loadedPanelDefinition, "/", 1);
                    panelDefinition.panel = loadedPanelDefinition.panel;
                    loadedDefinition = loadedPanelDefinition;
                    break;
                }
                default: {
                    return "\nERROR: Attempted to hotload unsuppoorted JSON type:" + (Object)((Object)definitionToOverride.classification);
                }
            }
            if (definitionToOverride instanceof AJSONItem) {
                ((AJSONItem)definitionToOverride).general = ((AJSONItem)loadedDefinition).general;
                if (definitionToOverride instanceof AJSONMultiModelProvider) {
                    ((AJSONMultiModelProvider)definitionToOverride).definitions = ((AJSONMultiModelProvider)loadedDefinition).definitions;
                    ((AJSONMultiModelProvider)definitionToOverride).variableModifiers = ((AJSONMultiModelProvider)loadedDefinition).variableModifiers;
                    ((AJSONMultiModelProvider)definitionToOverride).rendering = ((AJSONMultiModelProvider)loadedDefinition).rendering;
                    ((AJSONMultiModelProvider)definitionToOverride).constantValues = ((AJSONMultiModelProvider)loadedDefinition).constantValues;
                    for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)definitionToOverride).definitions) {
                        AItemSubTyped item = (AItemSubTyped)PackParser.getItem(definitionToOverride.packID, definitionToOverride.systemName, subDefinition.subName);
                        item.subDefinition = subDefinition;
                    }
                    if (definitionToOverride instanceof AJSONInteractableEntity) {
                        ((AJSONInteractableEntity)definitionToOverride).collisionGroups = ((AJSONInteractableEntity)loadedDefinition).collisionGroups;
                        ((AJSONInteractableEntity)definitionToOverride).connectionGroups = ((AJSONInteractableEntity)loadedDefinition).connectionGroups;
                        ((AJSONInteractableEntity)definitionToOverride).instruments = ((AJSONInteractableEntity)loadedDefinition).instruments;
                        ((AJSONInteractableEntity)definitionToOverride).customKeybinds = ((AJSONInteractableEntity)loadedDefinition).customKeybinds;
                        if (definitionToOverride instanceof AJSONPartProvider) {
                            ((AJSONPartProvider)definitionToOverride).parts = ((AJSONPartProvider)loadedDefinition).parts;
                        }
                    }
                }
            }
            return returnErrorsOnly ? "" : "\nImported file: " + definitionToOverride.packID + ":" + definitionToOverride.systemName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\nCould not import: " + definitionToOverride.packID + ":" + definitionToOverride.systemName + "\nERROR: " + e.getMessage();
        }
    }

    public static void validateFields(Object obj, String priorObjects, int index) {
        for (Field field : obj.getClass().getFields()) {
            String errorValue = JSONParser.checkRequiredState(field, obj, priorObjects, index);
            if (errorValue != null) {
                throw new NullPointerException(errorValue);
            }
            if (!obj.getClass().getPackage().getName().contains("jsondefs")) continue;
            Object recursiveObject = null;
            try {
                recursiveObject = field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (recursiveObject == null) continue;
            if (recursiveObject instanceof Collection) {
                int collectionIndex = 1;
                for (Object objEntry : (Collection)recursiveObject) {
                    if (objEntry != null) {
                        JSONParser.validateFields(objEntry, priorObjects + field.getName() + "/", collectionIndex);
                        ++collectionIndex;
                        continue;
                    }
                    throw new NullPointerException("Unable to parse entry #" + collectionIndex + " in variable set " + priorObjects + field.getName() + " due to it not existing.  Check your commas!");
                }
                continue;
            }
            if (recursiveObject.getClass().isEnum()) continue;
            JSONParser.validateFields(recursiveObject, priorObjects + field.getName() + "/", 1);
        }
    }

    private static String checkRequiredState(Field field, Object objectOn, String pathPrefix, int index) {
        if (field.isAnnotationPresent(JSONRequired.class)) {
            Object testObj = null;
            try {
                testObj = field.get(objectOn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (testObj == null) {
                JSONRequired annotation = field.getAnnotation(JSONRequired.class);
                String dependentVarName = annotation.dependentField();
                if (!dependentVarName.isEmpty()) {
                    Object depObj = null;
                    try {
                        if (annotation.subField().isEmpty()) {
                            depObj = objectOn.getClass().getField(dependentVarName).get(objectOn);
                        } else {
                            depObj = objectOn.getClass().getField(annotation.subField()).get(objectOn);
                            depObj = depObj.getClass().getField(dependentVarName).get(depObj);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (depObj != null) {
                        if (annotation.dependentValues().length == 0) {
                            return pathPrefix + field.getName() + ", entry #" + index + ", is required when '" + dependentVarName + "' is present!";
                        }
                        for (String possibleValue : annotation.dependentValues()) {
                            if (!depObj.toString().startsWith(possibleValue)) continue;
                            return pathPrefix + field.getName() + ", entry #" + index + ", is required when value of '" + dependentVarName + "' is '" + depObj + "'!";
                        }
                    }
                } else {
                    return pathPrefix + field.getName() + ", entry #" + index + ", is missing from the JSON and is required!";
                }
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface JSONDefaults {
        public Class<? extends Enum<?>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface JSONDescription {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface JSONRequired {
        public String dependentField() default "";

        public String[] dependentValues() default {};

        public String subField() default "";
    }
}

